#Libraries

if(!require(tidyverse)) install.packages("tidyverse") #for data wrangling etc
if(!require(brms))  install.packages("brms")     #for fitting models in STAN


#Read in data

terrestrial = read_csv('../data/Data_Table_1_Persistence_Data_Terrestrial.csv', trim_ws=TRUE)

#Reformat variables

terrestrial = terrestrial %>% mutate(
  Category=factor(Category),
  Func_Group=factor(Group),
  Threat=factor(Threat),
  Estimate=factor(Estimate),
  Level=factor(Level),
  Pers_fit_trans=sqrt(1-Persistence_fit))

#Subset threats

terrestrial_sub = terrestrial %>% filter(Threat == "Fire" | Threat == "Grazing" | Threat == "Buffalo"| Threat == "Cane toad"| Threat == "Cat"| Threat == "Pig"| Threat == "Perennial grasses") %>% droplevels()
unique(terrestrial_sub$Threat)

#Fit model

zoib_model_terrestrial1 <- bf(
  Persistence ~ Threat+Func_Group+Confidence+Level*Estimate+(1|Expert_ID),
  phi ~ Threat+Func_Group+Confidence+Level*Estimate+(1|Expert_ID),
  zoi ~ Threat+Func_Group+Confidence+Level*Estimate+(1|Expert_ID),
  coi ~ Threat+Func_Group+Confidence+Level*Estimate+(1|Expert_ID),
  family = zero_one_inflated_beta()
)


fit_terrestrial1 <- brm(
  formula = zoib_model_terrestrial1,
  data = terrestrial_sub,
  iter = 7000,
  chains = 3,
  warmup = 2000,
  thin = 1,
  cores = 8,
  seed = 12345,
  control = list(adapt_delta = 0.8, max_treedepth = 15),
  file = "brm-zoib-terrestrial1"
)

save(fit_terrestrial1,file="../data/ZOIB_aquatic1")
