##### Functions

##### Function to plot on a Pacific centered map
fun_points <- function(x){
  x[,1] <- x[,1] + center
  x[,1] <- ifelse(x[,1]>180,x[,1]-360,x[,1])
  if(sum(diff(x[,1])>300,na.rm=T) >0){
    id <- x[,1] < 0
    x <- rbind(x[id,],c(NA,NA),x[!id,])
  }
  x
}

#### Centre function
center_apply <- function(x) {
  apply(x, 2, function(y) y - mean(y))
}


#----- Plotting on a map according to defined central longitude point -----#
plot.map<- function(database,center,...){
  Obj <- maps::map(database,...,plot=F)
  coord <- cbind(Obj[[1]],Obj[[2]])
  
  # split up the coordinates
  id <- rle(!is.na(coord[,1]))
  id <- matrix(c(1,cumsum(id$lengths)),ncol=2,byrow=T)
  polygons <- apply(id,1,function(i){coord[i[1]:i[2],]})
  
  # split up polygons that differ too much
  polygons <- lapply(polygons,function(x){
    x[,1] <- x[,1] + center
    x[,1] <- ifelse(x[,1]>180,x[,1]-360,x[,1])
    if(sum(diff(x[,1])>300,na.rm=T) >0){
      id <- x[,1] < 0
      x <- rbind(x[id,],c(NA,NA),x[!id,])
    }
    x
  })
  # reconstruct the object
  polygons <- do.call(rbind,polygons)
  Obj[[1]] <- polygons[,1]
  Obj[[2]] <- polygons[,2]
  
  maps::map(Obj,...)
}