#!/bin/bash

# loop over all raw data RNAseq files in the directory
# print the filename (so we have some visual progress indicator)
# then run the file through the .slurm batch script which submits each file to fastQC, then fastp for trimming, then fastqc again

#Define environmental variable
in=/bucket/RavasiU/Jodi/01_Data/

for file in ${in}*R1*.fastq.gz; do
        echo ${file}
        sbatch 01_QCraw_2trim_QCtrimmed_parallel_two.slurm ${file} #submits the chosen file one at a time to the batch script and makes the chosen file a variable called 1
        sleep 2 # pause to be kind to the scheduler
done

