#!/bin/bash

#MultiQC to look at all QC reports together

#Define environmental variables
source activate /home/j/jodi-thomas/miniconda3/envs/QCenv/ #load conda environment called QCenv (has multiqc and fastp)

out=/flash/RavasiU/Jodi
inQC=/bucket/RavasiU/Jodi/02_2_Trim/02_2_QC_reports/

#MultiQC on fastp json reports - generated from fastp trimming but show raw and trimmed QC

multiqc ${inQC}*fastp.json \
        -n MultiQC_on_fastp_json_reports_2_length_filtered.html \
	--interactive \
        -o ${out}

#MultiQC on all FastQC outputs - before and after trimming

multiqc ${inQC}*fastqc.zip \
        -n MultiQC_on_fastqc_raw_and_trimmed_2_length_filtered.html \
	--interactive \
        -o ${out}

