#!/bin/bash

# loop over all trimmed (2_trim including length filter) RNAseq files in the directory
# print the filename (so we have some visual progress indicator)
# then run the file through the .slurm batch script which submits the kraken2 job for decontamination

#Define environmental variable
in=/bucket/RavasiU/Jodi//bucket/RavasiU/Jodi/02_2_Trim/02_2_Trimmed_data/

for file in ${in}*_R1_trimmed.fastq.gz; do
        echo ${file}
        sbatch 03_kraken2_parallel_two.slurm ${file} #submits the chosen file one at a time to the batch script and makes the chosen file a variable called 1
        sleep 2 # pause to be kind to the scheduler
done

