#!/bin/bash

# loop over all trimmed (2_trim fastp with length filter < 30 bp) and decontaminated (kraken2 bacterial, arcaheal, 0.3 confidence) files in the directory
# print the filename (so we have some visual progress indicator)
# then run the file through the .slurm batch script to do fastqc after kraken2 decontamination

#Define environmental variable
in=/bucket/RavasiU/Jodi/02_Kraken2_2trimmed_bact_arch_conf0.3/

for file in ${in}*_unclassified_1.fastq; do
        echo ${file}
        sbatch 04_fastQC_afterkraken2_parallel_two.slurm ${file} #submits the chosen file one at a time to the batch script and makes the chosen file a variable called 1
        sleep 2 # pause to be kind to the scheduler
done
