#!/bin/bash

#MuliQC on fastQC reports before and after kraken2 decontamination
#Before kraken2 = trimmed RNAseq (fastp 2_Trim using length filter < 30 bp)
#After kraken2 = done on this 2Trim seqs decontaminating bacterial and archaeal seqs with confidence 0.3

#Define environmental variables
source activate /home/j/jodi-thomas/miniconda3/envs/QCenv/ #load conda environment called QCenv (has multiqc and fastp)

out=/flash/RavasiU/Jodi/
intrimmed=/bucket/RavasiU/Jodi/02_2_Trim/02_2_QC_reports/
inkraken2=/bucket/RavasiU/Jodi/02_QC_2Trim_kraken2_bact_arch_conf0.3/

multiqc ${intrimmed}*_trimmed_fastqc.zip ${inkraken2}*_unclassified_*fastqc.zip \
        -n MultiQC_on_fastqc_2trim_length_filter_kraken2_bact_arch_conf0.3.html \
        --interactive \
        -o ${out}

