#!/bin/bash
# loop over all individual RNAseq files (2trim and decontaminated)
# print the file name (so we have some visual progress indicator)
# then run the file through the .slurm batch script which submits RNAseq samples to bowtie2 for alignment to the indexed transcriptome assembly

#Define environmental variable
in=/bucket/RavasiU/Jodi/RNAseq/02_Kraken2_outputs_2Trim_bact_arch_conf0.3/

for file in ${in}*_unclassified_1.fastq; do
        echo ${file}
        sbatch 01_2_bowtie2_align_isoseq3_cdhit0.99_parallel_two.slurm ${file} #submits the chosen file one at a time to the batch script and makes it a variable called 1
        sleep 2 # pause to be kind to the scheduler
done

